package logic;

public class BooleanFactory implements IBooleanFactory {
  
  public static final BooleanFactory Singleton = new BooleanFactory();
  
  private BooleanFactory(){}
  
  private static IBoolean trueBoolean = new IBoolean() {
    public Object execute(IBooleanAlgo algo, Object... inp) {
      return algo.trueCase(this, inp);
    }
  };
  
  private static IBoolean falseBoolean = new IBoolean() {
    public Object execute(IBooleanAlgo algo, Object...inp) {
      return algo.falseCase(this, inp);
    }
  };
  
  public IBoolean makeBoolean(boolean b) {
    return b ? trueBoolean : falseBoolean;
  }
}